/****************************************************************************
 *   $Id:: i2ctest.c 3662 2012-10-31 19:47:02Z usb00423                     $
 *   Project: NXP LPC8xx I2C example
 *
 *   Description:
 *     This file contains I2C test modules, main entry, to test I2C APIs.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation is hereby granted, under NXP Semiconductors' 
 * relevant copyright in the software, without fee, provided that it 
 * is used in conjunction with NXP Semiconductors microcontrollers. This 
 * copyright, permission, and disclaimer notice must appear in all copies of 
 * this code.
****************************************************************************/
#include "LPC8xx.h"			/* LPC8xx Peripheral Registers */
#include "type.h"
#include "lpc8xx_i2c.h"
#include "lpc8xx_pmu.h"

volatile uint8_t I2CMasterTXBuffer[I2C_BUFSIZE];
volatile uint8_t I2CMasterRXBuffer[I2C_BUFSIZE];
volatile uint8_t I2CSlaveTXBuffer[I2C_BUFSIZE];
volatile uint8_t I2CSlaveRXBuffer[I2C_BUFSIZE];
volatile uint32_t I2CMonBuffer[I2C_MONBUFSIZE];
volatile uint32_t I2CReadLength, I2CWriteLength;

extern uint32_t I2CSlvRXCount;
extern uint32_t I2CSlvDeselectedCount;

void SysTick_Handler(void) {
  LPC_GPIO_PORT->NOT0 = (1<<7);
}

void PowerDownMode(void) {
	I2CSlaveRXBuffer[0] = 0; 				/* clear the data buffer	*/
	LPC_GPIO_PORT->SET0 = (1<<7);		/* turn off LED						*/
	PMU_Sleep(MCU_POWER_DOWN, 0);		/* power-down enabled			*/

}

/*****************************************************************************
** Function name:		Main
**

** Descriptions:		Main entry
** parameters:			None
** Returned value:	int
** 
*****************************************************************************/
int main (void) 
{                       /* Main Program */
  uint32_t regVal;
  
  SystemCoreClockUpdate();

	/*connect the I2C SCL and SDA sigals to port pins(P0.10-P0.11)*/
  regVal = LPC_SWM->PINASSIGN7 & ~(0xFFUL<<24);
  LPC_SWM->PINASSIGN7 = regVal | (10 << 24);	/* P0.10 is I2C SDA, ASSIGN0(31:24) */
  regVal = LPC_SWM->PINASSIGN8 & ~(0xFF<<0);
  LPC_SWM->PINASSIGN8 = regVal | (11 << 0);		/* P0.11 is I2C SCL. ASSIGN0(7:0) */

	LPC_SYSCON->CLKOUTDIV = 120;	/* CLKOUT = 60E6 / 120 = 500 kHz 	*/
  LPC_SYSCON->CLKOUTSEL = 0x03; /* CLKOUT = Main clock 						*/
	LPC_SYSCON->CLKOUTUEN = 0x01; /* Update CLKOUT Source      			*/
	
	LPC_GPIO_PORT->DIR0 |= (1<<5);
	regVal = LPC_SWM->PINASSIGN8 & ~(0xFF<<16);
  LPC_SWM->PINASSIGN8 = regVal | (0x0F << 16); /* P0.15 is CLKOUT. ASSIGN8(23:16) */
	
	LPC_GPIO_PORT->DIR0 |= (1<<7);
	SysTick_Config( SystemCoreClock / 2 );

	/* Enable I2C clock */
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<5);
	/* Toggle peripheral reset control to I2C, a "1" bring it out of reset. */
	LPC_SYSCON->PRESETCTRL &= ~(0x1<<6);
	LPC_SYSCON->PRESETCTRL |= (0x1<<6);

  I2C_SlvInit(LPC_I2C, SLAVE_ADDR, CFG_SLVENA, I2C_FMODE_PRE_DIV);
  /* Ready to receive the slave address, interrupt(SLAVE ADDR STATE) if match occurs. */
  LPC_I2C->SLVCTL = CTL_SLVCONTINUE;
  LPC_I2C->INTENSET = STAT_SLVPEND;  

	/* Enable wake from power down using I2C */
	LPC_SYSCON->STARTERP1 |= (1<<8);
	
  while ( 1 ) {
	
	if ( (I2CSlvRXCount > 0 ) && (I2CSlvDeselectedCount>0) ){	/* received data and Stop detected	*/
				I2CSlvRXCount = 0;																	/* reset the slave byte counter	*/
				I2CSlvDeselectedCount = 0;
				if (I2CSlaveRXBuffer[0] == 0xAA)										/* check if 0xAA was received ... if so, enter Power-down mode */
					PowerDownMode();
		}
	}
}
/******************************************************************************
**                            End Of File
******************************************************************************/
